import json
import sys
sys.path.insert(0, '/var/www/cgi-bin')
import logging_rpi
import BackhaulConfiguration
sys.path.insert(0, '/home/pi/Pulsar')
from BackhaulSubscribe import BackhaulSubscribe
from Backhaul import Backhaul
import os, time
import random

# This script first 

class InternalQueueListener:

    def __init__(self, internalQueue, module, **kwargs):
        self.internalQueue = internalQueue
        self.backhaul = Backhaul(self.internalQueue)
        self.subscriber = BackhaulSubscribe(queueName=self.internalQueue, publish=False)
        self.module = module
        self.data = None

    def listen(self):

        while True:
            self.subscriber.listenRabbitMQ(getOne=True)
            data = json.loads(self.subscriber.result)
            
            try:
                self.data = None
                if data['Topic'] == self.module:
                    self.data = data 
                    result = self.main()
                    if result is False or result is None:
                        logging_rpi.log.error("PrivateQueueListener:::instanced main function error:::accepted module name but encountered error:"+str(data))
                        self.resendData(data)
                else:
                    print "{0} module is not requested. Requeuing.".format(data['Topic'])
                    self.resendData(data)
            except KeyError as e:
                logging_rpi.log.error("PrivateQueueListener:::main function error:::" + str(e))
                self.resendData(data)
                logging_rpi.log.info("PrivateQueueListener:::main function error:::Data requeued due to exception")
                continue

    def resendData(self, data):
        self.backhaul.send(data)
        time.sleep(random.randint(0, 15))

    def main(self):
        print "=+==+==+==+==+==+==+==+==+==+==+==+==+==+==+==+==+==+==+==+="
        print "Please overwrite this function."
        print "Data can be retrieved via this object's data class variable."
        print "Return false to requeue data. Return True is to burn the data forever. Thank you!"
        print self.data